IF OBJECT_ID('P_EST_SNGPC_SAIDA_TRANSF_INCLUIR') IS NOT NULL
	BEGIN
		DROP PROCEDURE P_EST_SNGPC_SAIDA_TRANSF_INCLUIR;
	END;
GO

CREATE PROCEDURE P_EST_SNGPC_SAIDA_TRANSF_INCLUIR(@PCODIGOMOVTRANSFERENCIA INT
												, @PCODIGOEMPRESA          INT
												, @PCODIGOFILIAL           INT
												, @PCODIGOLOTE             INT
												, @PDATA                   DATETIME
												, @PQTDE                   INT
												, @PCODIGOUSUARIO          INT
												, @PCODIGONOTA             INT
												, @PCODIGOMEDICAMENTO      INT
												, @PCODIGOITEM             INT)
AS
	
	 SET NOCOUNT ON; 

	 DECLARE
			@CODIGO INT;
	 DECLARE
			@DATA DATETIME;
	 DECLARE
			@QTDE INT;
	 DECLARE
			@ERROR VARCHAR(MAX);
	 DECLARE
			@OPERACAO VARCHAR(MAX);



	BEGIN TRY 
		SET @DATA = GETDATE();
		SET @QTDE =
		(
			SELECT QT_LOTE
			FROM EST_SNGPC_SAIDA
			WHERE CD_SAI_SNGPC = @PCODIGOMOVTRANSFERENCIA
		);

		IF @QTDE IS NULL
			BEGIN
				SET @OPERACAO = 'INSERT MOV.TRANSFERENCIA';
				INSERT INTO EST_SNGPC_SAIDA
				(CD_EMP
			   , CD_FILIAL
			   , CD_LOTE
			   , DT_MOV
			   , QT_LOTE
			   , DT_ULT_ALT
			   , CD_USU
				)
				VALUES
				(@PCODIGOEMPRESA
			   , @PCODIGOFILIAL
			   , @PCODIGOLOTE
			   , @PDATA
			   , @PQTDE
			   , @DATA
			   , @PCODIGOUSUARIO
				);
				SET @CODIGO =
				(
					SELECT MAX(CD_SAI_SNGPC)
					FROM EST_SNGPC_SAIDA
					WHERE CD_EMP = @PCODIGOEMPRESA
						  AND CD_FILIAL = @PCODIGOFILIAL
						  AND CD_LOTE = @PCODIGOLOTE
						  AND CD_USU = @PCODIGOUSUARIO
				);

				INSERT INTO EST_NF_SAI_IT_EST_SNGPC_SAIDA
				(CD_SAI_SNGPC
			   , CD_EMP
			   , CD_FILIAL
			   , CD_NF
			   , CD_PROD
			   , CD_IT
				)
				VALUES
				(@CODIGO
			   , @PCODIGOEMPRESA
			   , @PCODIGOFILIAL
			   , @PCODIGONOTA
			   , @PCODIGOMEDICAMENTO
			   , @PCODIGOITEM
				);
				SET @QTDE = @PQTDE;
			END;
		ELSE
			BEGIN
				SET @OPERACAO = 'UPDATE MOV.TRANSFERENCIA';
				UPDATE EST_SNGPC_SAIDA
				  SET
					  DT_MOV = @PDATA
					, QT_LOTE = @PQTDE
					, DT_ULT_ALT = @DATA
					, CD_USU = @PCODIGOUSUARIO
				WHERE CD_SAI_SNGPC = @PCODIGOMOVTRANSFERENCIA;
				SET @CODIGO = @PCODIGOMOVTRANSFERENCIA;
				SET @QTDE = @PQTDE - @QTDE;
				UPDATE EST_NF_SAI_IT_EST_SNGPC_SAIDA
				  SET
					  CD_EMP = @PCODIGOEMPRESA
				WHERE CD_SAI_SNGPC = @PCODIGOMOVTRANSFERENCIA;
			END;
		UPDATE EST_PROD_EST_SNGPC_LOTE_CPL
		  SET
			  QT_LOTE = (QT_LOTE - @QTDE)
		WHERE CD_EMP = @PCODIGOEMPRESA
			  AND CD_FILIAL = @PCODIGOFILIAL
			  AND CD_LOTE = @PCODIGOLOTE;
		UPDATE EST_NF_SAI_IT_EST_SNGPC_SAIDA
		  SET
			  CD_EMP = @PCODIGOEMPRESA
		WHERE CD_SAI_SNGPC = @PCODIGOMOVTRANSFERENCIA;
		SELECT @DATA AS DT_ULT_ALT
			 , @CODIGO AS CD_SAI_SNGPC;
		INSERT INTO SNGPC_HIST_MOV_LOTE
		(CD_EMP
	   , CD_FILIAL
	   , CD_PROD
	   , LOTE
	   , TIPO_MOV
	   , CD_MOV
	   , DT_MOV
	   , CD_USU
	   , QT_MOV
		)
		VALUES
		(@PCODIGOEMPRESA
	   , @PCODIGOFILIAL
	   , 0
	   , @PCODIGOLOTE
	   , @OPERACAO
	   , @CODIGO
	   , GETDATE()
	   , @PCODIGOUSUARIO
	   , @PQTDE
		);
		 
	END TRY
	BEGIN CATCH
		BEGIN TRY
			ROLLBACK;
		END TRY
		BEGIN CATCH
		END CATCH;
		SET @ERROR = ERROR_MESSAGE();
		RAISERROR(@ERROR, 16, 1);
	END CATCH;